﻿<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<script runat="server">

	static readonly string seperator = new String('-', 80);
	
    void OnLoad(Object sender, EventArgs args) {
        DokumentHandlowy dok = (DokumentHandlowy)dc.Get(typeof(DokumentHandlowy));
		Zaplata zapłata = dok.Zapłata;
		if (zapłata==null)
			throw new RowException(dok, "Dla dokumentu nie wprowadzono zapłaty. Wydruk KP/KW nie jest możliwy.");
        
        decimal kw = Soneta.Tools.Math.Floor(zapłata.Kwota.Value);
        decimal gr = 100*(zapłata.Kwota.Value - kw);
		bool wpłata = zapłata is Wplata;
        CoreModule core = CoreModule.GetInstance(dc);
           
        Header1.EditValue = SX(Left(core.Config.Firma.Pieczątka.NazwaSkrócona, 50)) + "| " + (wpłata ? "<B>KP</B>" : "<B>KW</B>");
        Header2.EditValue = SX(Left(core.Config.Firma.AdresSiedziby.Linia1, 50))    + "| Kasa:  " + SX(zapłata.EwidencjaSP.Nazwa);
        Header3.EditValue = SX(Left(core.Config.Firma.AdresSiedziby.Linia2, 50))    + "| Numer: " + SX(zapłata.NumerDokumentu);
        Header4.EditValue = SX(Left("NIP: " + core.Config.Firma.Pieczątka.NIP, 50)) + "| Data:  " + zapłata.DataDokumentu;
        
        Info1.EditValue = seperator;
        if (wpłata)
			Info2.EditValue = new String(' ', 21) + "Od kogo " + new String(' ', 21) + "|        Wpłata";
		else
			Info2.EditValue = new String(' ', 21) + "Dla kogo" + new String(' ', 21) + "|        Wyłata";
        Info3.EditValue = SX(Left(zapłata.DaneKontrahenta.Nazwa, 50)) +                "|       zł    gr";
        Info4.EditValue = SX(Left(zapłata.DaneKontrahenta.Adres.Linia1, 50)) +         "|";
        Info5.EditValue = SX(Left(zapłata.DaneKontrahenta.Adres.Linia2, 50)) +         "|      " + ((int)kw).ToString("######") + "    " + ((int)gr).ToString("00");
        Info6.EditValue = Left("NIP: "+ zapłata.DaneKontrahenta.NIP, 50) +         "|";
        Info7.EditValue = seperator;
        string ss = "";
		if (zapłata.SposobZaplaty.Typ!=TypySposobowZaplaty.Gotówka) {
			ss = Clip("Sposób zapłaty: " + zapłata.SposobZaplaty, 80);
			ss += "<br>" + seperator + "<br>";
		}
        Opis1.EditValue = ss + SX(Clip("Opis:           " + zapłata.Opis, 80));
        Opis2.EditValue = seperator;
        
        Slownie1.EditValue = Clip("Słownie:        " + zapłata.Słownie, 80);
        Slownie2.EditValue = seperator;
        
        Footer1.EditValue = " Sporządził | Sprawdził  | Zatwierdził |     Raport kasowy     | Kwotę powyższą";
        Footer2.EditValue = "            |            |             |                       |   otrzymałem";
        Footer3.EditValue = "            |            |             |"+SX(Center(zapłata.Raport.NumerRaportu,23))+"|";
        Footer4.EditValue = " .......... | .......... | ..........  |"+Center("Pozycja: "+zapłata.Lp, 23)+"|   ..........";
        Copyright.EditValue = Right(dc.Copyright, 80);
    }

	bool first = true;
	
	void Section1_BeforeRender(Object sender, EventArgs e) {
		if (first) {
			first = false;
			Divider.EditValue = "<br><br><br><br><br>";
		}
		else	
			Divider.EditValue = "";
	}

	string Center(string value, int len) {
        if (value.Length>len)
            return value.Substring(0, len);
        int delta = len - value.Length;
        int a = delta/2;
		return Right(Left(value, value.Length+a), len);
	}
	
    string Left(string value, int len) {
        if (value.Length>len)
            return value.Substring(0, len);
        return value.PadRight(len);
    }
    
    string Right(string value, int len) {
        if (value.Length>len)
            return value.Substring(0, len);
        return value.PadLeft(len);
    }
    
    string Clip(string value, int len) {
        if (value.Length>len)
            return value.Substring(0, len);
        return value;
	}

	static string SX(string ss) {
		return HttpUtility.HtmlEncode(ss);
	}
		
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=unicode">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="KPKW2" method="post" runat="server" onload="OnLoad">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"></ea:datacontext><small><ea:section id="Section1" runat="server" OnBeforeRender="Section1_BeforeRender" Width="100%"
					Height="252px"><PRE>
<ea:DataLabel id=Header1 runat="server"></ea:DataLabel>
<ea:DataLabel id=Header2 runat="server"></ea:DataLabel>
<ea:DataLabel id=Header3 runat="server"></ea:DataLabel>
<ea:DataLabel id=Header4 runat="server"></ea:DataLabel>
<ea:DataLabel id=Info1 runat="server"></ea:DataLabel>
<ea:DataLabel id=Info2 runat="server"></ea:DataLabel>
<ea:DataLabel id=Info3 runat="server"></ea:DataLabel>
<ea:DataLabel id=Info4 runat="server"></ea:DataLabel>
<ea:DataLabel id=Info5 runat="server"></ea:DataLabel>
<ea:DataLabel id=Info6 runat="server"></ea:DataLabel>
<ea:DataLabel id=Info7 runat="server"></ea:DataLabel>
<ea:DataLabel id=Opis1 runat="server"></ea:DataLabel>
<ea:DataLabel id=Opis2 runat="server"></ea:DataLabel>
<ea:DataLabel id=Slownie1 runat="server"></ea:DataLabel>
<ea:DataLabel id=Slownie2 runat="server"></ea:DataLabel>
<ea:DataLabel id=Footer1 runat="server"></ea:DataLabel>
<ea:DataLabel id=Footer2 runat="server"></ea:DataLabel>
<ea:DataLabel id=Footer3 runat="server"></ea:DataLabel>
<ea:DataLabel id=Footer4 runat="server"></ea:DataLabel>
<ea:DataLabel id=Copyright runat="server"></ea:DataLabel>
<ea:DataLabel id=Divider runat="server"></ea:DataLabel></PRE>
				</ea:section><ea:pagebreak id="PageBreak1" runat="server"></ea:pagebreak></small></form>
	</body>
</HTML>

